const Joi = require('@hapi/joi');

// create request object
const create = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    hostId: Joi.string().required(),
    hostName: Joi.string().required().allow(''),
    hostEmail: Joi.string().required().email(),
    meetingName: Joi.string().required(),
    meetingPassword: Joi.string().required().allow(''),
    isPasswordEnabled: Joi.boolean().required(),
    sessionType: Joi.string().required(),
  }),
};

// Get meeting request object
const get = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingCode: Joi.string().required(),
    userId: Joi.string().required(),
  }),
};

// Validate meeting object
const validate = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingCode: Joi.string().required(),
    meetingPassword: Joi.string().required().allow(''),
    userId: Joi.string().required(),
  }),
};

const updateUser = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingName: Joi.string().required(),
    userName: Joi.string().required(),
  }),
};

const join = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingCode: Joi.string().required(),
    userId: Joi.string().required(),
    userName: Joi.string().required(),
  }),
};

// create request object
const meet = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    hostId: Joi.string().required(),
    hostName: Joi.string().required().allow(''), // Allows an empty string if required
    hostEmail: Joi.string().required().email(),
    meetingName: Joi.string().required(),
    meetingPassword: Joi.string().allow(''), // Allows an empty string for password
    isPasswordEnabled: Joi.boolean().required(),
    sessionType: Joi.string().required(),
    duration: Joi.number().required(),  // Removed .allow('')
    endedAt: Joi.date().required().allow(''), // Removed .allow('')
    startedAt: Joi.date().required().allow(''), // Removed .allow('')
  }),
};

const ping = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingCode: Joi.string().required(),
    userId: Joi.string(),
  }),
};

const reopen = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingCode: Joi.string().required(),
    userId: Joi.string(),
  }),
};

const chat = {
  params: Joi.object().keys({
    apiKey: Joi.string().required(),
    meetingCode: Joi.string(),
    chatObj: Joi.string(),
  }),
};

module.exports = {
  create,
  validate,
  join,
  ping,
  reopen,
  updateUser,
  get,
  chat,
};
