const Joi = require('@hapi/joi');

const newRecording = {
  body: Joi.object().keys({
    validationCode: Joi.string().required(),
    hostEmail: Joi.string().email().required(),
    meetingCode: Joi.string().required(),
    mediaUrl: Joi.string().required(),
    alternateMediaUrl: Joi.string().required(),
    fileName: Joi.string(),
    fileSize: Joi.string(),
  }),
};

const deleteMedia = {
  body: Joi.object().keys({
    hostEmail: Joi.string().required(),
    meetingCode: Joi.string().required(),
    mediaUrl: Joi.string().required(),
    type: Joi.string().required(),
  }),
};

const mediaUserId = {
  body: Joi.object().keys({
    userId: Joi.string().required(),
  }),
};

module.exports = {
  newRecording,
  mediaUserId,
  deleteMedia,
};
