const Joi = require('@hapi/joi');

const create = {
  body: Joi.object().keys({
    apiKey: Joi.string().required(),
    hostId: Joi.string().required(),
    hostName: Joi.string().required(),
    hostEmail: Joi.string().required().email(),
    meetingName: Joi.string().required(),
    meetingPassword: Joi.string().required().allow(''),
    sessionType: Joi.string().required(),
    invitees: Joi.array(),
  }),
};

const validate = {
  body: Joi.object().keys({
    apiKey: Joi.string(),
    meetingId: Joi.string().required(),
    password: Joi.string().required(),
    userId: Joi.string(),
  }),
};

const update = {
  body: Joi.object().keys({
    apiKey: Joi.string(),
    meetingId: Joi.string(),
    userId: Joi.string(),
  }),
};

const ping = {
  body: Joi.object().keys({
    apiKey: Joi.string(),
    meetingId: Joi.string(),
    userId: Joi.string(),
  }),
};

const setAttendee = {
  body: Joi.object().keys({
    apiKey: Joi.string(),
    meetingId: Joi.string(),
    user: Joi.object(),
  }),
};

const getMeetByName = {
  body: Joi.object().keys({
    apiKey: Joi.string(),
    meetingName: Joi.string(),
  }),
};

module.exports = {
  create,
  update,
  validate,
  ping,
  getMeetByName,
  setAttendee,
};
