const { Server, Meet } = require('../models');
const logger = require('../config/logger');

const getAvailableServer = () => {
  return new Promise((resolve, reject) => {
    Server.find({ isActive: true }, (err, servers) => {
      if (err || servers.length === 0) {
        logger.error(err);
        return reject(new Error('No servers available at the moment'));
      }

      const serverUsage = [];

      // Check all servers for active sessions
      servers.forEach(async (server, index) => {
        const meet = await Meet.find({
          serverId: server.id,
          isActive: true,
        });

        if (meet.length === 0 || servers.length === 1) {
          return resolve(server);
        }

        serverUsage.push({
          serverId: server.id,
          activeSessions: meet.length,
        });

        // Return server with least number of active sessions
        if (servers.length - 1 === index) {
          const bestServer = Math.min(...serverUsage.map((o) => o.activeSessions), 0);
          return resolve(bestServer);
        }
      });
    });
  });
};

module.exports = {
  getAvailableServer,
};
