const httpStatus = require('http-status');
const { Page } = require('../models');
const ApiError = require('../utils/ApiError');

/**
 * Get user by id
 * @param {ObjectId} id
 * @returns {Promise<User>}
 */
const getMeetById = async (id) => {
  return Page.findById(id);
};

/**
 * Update user by id
 * @param {ObjectId} pageId
 * @param {Object} updateBody
 * @returns {Promise<User>}
 */
const updatePage = async (pageId, updateBody) => {
  const page = await getMeetById(pageId);
  if (!page) {
    throw new ApiError(httpStatus.NOT_FOUND, 'Page does not exist');
  }

  Object.assign(page, updateBody);
  await page.save();
  return page;
};

module.exports = {
  updatePage,
  getMeetById,
};
