const express = require('express');
const validate = require('../../middlewares/validate');
const { meetValidation } = require('../../validations');
const { meetController } = require('../../controllers');

const router = express.Router();

router.route('/create').post(validate(meetValidation.create), meetController.createNewMeeting);
router.route('/get').post(validate(meetValidation.get), meetController.getMeetingByCode);
router.route('/validate').post(validate(meetValidation.validate), meetController.validateMeeting);
router.route('/join').post(validate(meetValidation.join), meetController.joinMeeting);
router.route('/ping').post(validate(meetValidation.ping), meetController.pingAttendee);
router.route('/reopen').post(validate(meetValidation.reopen), meetController.reopenMeeting);

// router.route('/getMeetDetails').post(validate(meetValidation.join), meetController.getActiveMeetingByName);
// router.route('/setAttendee').post(validate(meetValidation.join), meetController.insertAttendee);
// router.route('/updateMeetUser').post(validate(meetValidation.updateUser), meetController.updateMeetingUser);

// router.route('/chat').post(validate(meetValidation.chat), meetController.updateMeetingChat);
router.route('/meet').post(validate(meetValidation.meet), meetController.createNewMeetingForOthers);
module.exports = router;
