const express = require('express');
const validate = require('../../middlewares/validate');
const mediaController = require('../../controllers/media.controller');
const auth = require('../../middlewares/auth');
const mediaValidation = require('../../validations/media.validation');

const router = express.Router();

// GET
router.get('/screenshots', auth('auth'), mediaController.getAllScreenshots);
router.get('/recordings', auth('auth'), mediaController.getAllRecordings);

// POST
router.post('/upload-screenshot', auth('media'), mediaController.uploadScreenshot);
router.post('/create-recording', validate(mediaValidation.newRecording), mediaController.createNewRecording);
router.post('/screenshots', auth('media'), validate(mediaValidation.mediaUserId), mediaController.getUserScreenshots);
router.post('/recordings', auth('media'), validate(mediaValidation.mediaUserId), mediaController.getUserScreenshots);
router.post('/delete', auth('media'), validate(mediaValidation.deleteMedia), mediaController.deleteMedia);

module.exports = router;
