const express = require('express');
const validate = require('../../middlewares/validate');
const apiValidation = require('../../validations/api.validation');
const apiController = require('../../controllers/api.controller');

const router = express.Router();

// Create new meeting
router.route('/create-meeting').post(validate(apiValidation.create), apiController.createMeeting);
router.route('/get-meet').post(validate(apiValidation.update), apiController.getMeetingByID);
router.route('/update-meet').post(validate(apiValidation.update), apiController.updateMeeting);
router.route('/set-attendee').post(validate(apiValidation.setAttendee), apiController.insertAttendee);
router.route('/ping').post(validate(apiValidation.ping), apiController.pingAttendee);
router.route('/validate-meet').post(validate(apiValidation.validate), apiController.validateMeeting);
router.route('/check-meeting').post(validate(apiValidation.getMeetByName), apiController.getActiveMeetingIdByMeetingName);

module.exports = router;
