const mongoose = require('mongoose');

mongoose.set('useFindAndModify', false);

const serverSchema = mongoose.Schema({
  serverName: {
    type: String,
    required: true,
  },
  serverIp: {
    type: String,
    required: true,
  },
  serverURL: {
    type: String,
    required: true,
  },
  serverType: {
    type: String,
    required: true,
  },
  isActive: {
    type: Boolean,
    default: true,
  },
});

/**
 * @typedef Servers
 */
const Servers = mongoose.model('Servers', serverSchema);

module.exports = Servers;
