const mongoose = require('mongoose');
const { toJSON } = require('./plugins');

const pageSchema = mongoose.Schema({
  title: {
    type: String,
    required: true,
    trim: true,
  },
  content: {
    type: String,
    required: true,
    trim: true,
  },
});

// add plugin that converts mongoose to json
pageSchema.plugin(toJSON);

/**
 * @typedef Page
 */
const Page = mongoose.model('Page', pageSchema);

module.exports = Page;
