const mongoose = require('mongoose');

mongoose.set('useFindAndModify', false);
const { toJSON } = require('./plugins');
const { meetingTypes } = require('../config/enum');
const { date } = require('@hapi/joi');

const meetSchema = mongoose.Schema(
  {
    meetingCode: {
      type: String,
      required: true,
      trim: true,
    },
    meetingName: {
      type: String,
      required: true,
      trim: true,
    },
    meetingPassword: {
      type: String,
      default: '',
    },
    isPasswordEnabled: {
      type: Boolean,
      default: false,
    },
    serverId: {
      type: String,
      required: true,
      trim: true,
    },
    serverURL: {
      type: String,
      required: true,
      trim: true,
    },
    sessionType: {
      type: String,
      required: true,
      enum: meetingTypes,
      default: 'OTM',
    },
    hostId: {
      type: String,
      required: true,
      trim: true,
    },
    hostName: {
      type: String,
      required: true,
      trim: true,
    },
    hostEmail: {
      type: String,
      required: true,
      trim: true,
    },
    isActive: {
      type: Boolean,
      default: true,
    },
    endedAt: {
      type: Date,
      default: '',
    },
    startedAt: {
      type: Date,
      default: '',
    },
    duration: {
      type: String,
      default: '',
    },
  },
  {
    timestamps: true,
  }
);

// add plugin that converts mongoose to json
meetSchema.plugin(toJSON);

/**
 * @typedef Meet
 */
const Meet = mongoose.model('Meet', meetSchema);

module.exports = Meet;
