const mongoose = require('mongoose');

const mediaSchema = mongoose.Schema(
  {
    hostName: {
      type: String,
      required: true,
      trim: true,
    },
    hostEmail: {
      type: String,
      required: true,
      trim: true,
    },
    meetingId: {
      type: String,
      required: true,
      trim: true,
    },
    meetingCode: {
      type: String,
      required: true,
      trim: true,
    },
    mediaType: {
      type: String,
      required: true,
      trim: true,
      private: true,
    },
    fileName: {
      type: String,
      trim: true,
    },
    fileSize: {
      type: String,
      trim: true,
    },
    mediaUrl: {
      type: String,
      required: true,
      trim: true,
    },
    alternateMediaUrl: {
      type: String,
      required: true,
      trim: true,
    },
  },
  {
    timestamps: true,
  }
);

/**
 * @typedef Media
 */
const Media = mongoose.model('Media', mediaSchema);

module.exports = Media;
