const mongoose = require('mongoose');
const { statusCodes } = require('../config/enum');

const licenseSchema = mongoose.Schema(
  {
    email: {
      type: String,
      required: true,
      trim: true,
      lowercase: true,
    },
    licenseKey: {
      type: String,
      required: true,
      trim: true,
      lowercase: true,
      unique: true,
    },
    status: {
      type: String,
      enum: statusCodes,
      default: 'active',
    },
    userLimit: {
      type: Number,
      required: true,
      default: 10,
    },
    expiryDays: {
      type: String,
      required: true,
    },
    expiryDate: {
      type: String,
      required: true,
    },
    renewedAt: {
      type: String,
      required: true,
    },
  },
  {
    timestamps: true,
  }
);

/**
 * Check if licenseKey is taken
 * @param {string} licenseKey - The user's licenseKey
 * @param {ObjectId} [excludeLicenseKey] - The id of the user to be excluded
 * @returns {Promise<boolean>}
 */
licenseSchema.statics.isLicenseTaken = async function (licenseKey, excludeLicenseKey) {
  const license = await this.findOne({ licenseKey, _id: { $ne: excludeLicenseKey } });
  return !!license;
};

/**
 * @typedef License
 */
const License = mongoose.model('License', licenseSchema);

module.exports = License;
