/* eslint-disable */

const mongoose = require('mongoose');

mongoose.set('useFindAndModify', false);
const { toJSON } = require('./plugins');

const attendeesSchema = mongoose.Schema(
    {
        meetingId: {
            type: String,
            required: true,
            trim: true,
        },
        attendees: {
            type: Object,
            default: [],
        },
    },
    {
        timestamps: true,
    }
);

// add plugin that converts mongoose to json
attendeesSchema.plugin(toJSON);

/**
 * @typedef Attendees
 */
const Attendees = mongoose.model('Attendees', attendeesSchema);

module.exports = Attendees;
