const httpStatus = require('http-status');
const config = require('../config/config');
const logger = require('../config/logger');

const errorConverter = (err, req, res, next) => {
  const error = err;
  const statusCode = error.statusCode || httpStatus.INTERNAL_SERVER_ERROR;
  const message = error.message || httpStatus[statusCode];
  next({
    statusCode,
    message,
  });
};

// eslint-disable-next-line no-unused-vars
const errorHandler = (err, req, res, next) => {
  let { statusCode, message } = err;
  if (config.env === 'production' && !err.isOperational) {
    statusCode = httpStatus.INTERNAL_SERVER_ERROR;
    message = httpStatus[httpStatus.INTERNAL_SERVER_ERROR];
  }

  res.locals.errorMessage = err.message;

  const response = {
    code: statusCode,
    message,
    ...(config.env === 'development' && { stack: err.stack }),
  };

  if (config.env === 'development') {
    logger.error(err);
  }

  res.status(statusCode).send(response);
};

module.exports = {
  errorConverter,
  errorHandler,
};
