const mongoose = require('mongoose');
const https = require('https');
const fs = require('fs');
const app = require('./app');
const config = require('./config/config');
const logger = require('./config/logger');
const { StartSocketConnection } = require('./socket');

const options = {
  key: fs.readFileSync('ssl/privkey.key'),
  cert: fs.readFileSync('ssl/fullchain.pem'),
};

let server;
mongoose.connect(config.mongoose.url, config.mongoose.options).then(() => {
  logger.info('Connected to MongoDB');

  const httpsServer = https.createServer(options, app).listen(8081, () => {
    logger.info('Listening to port 8081');
    StartSocketConnection(httpsServer);
  });
});

const exitHandler = () => {
  if (server) {
    server.close(() => {
      logger.info('Server closed');
      process.exit(1);
    });
  } else {
    process.exit(1);
  }
};

process.on('uncaughtException', (error) => {
  logger.error('Uncaught Exception:', error);
  exitHandler();
});

process.on('unhandledRejection', (error) => {
  logger.error('Unhandled Rejection:', error);
  exitHandler();
});

process.on('SIGTERM', () => {
  logger.info('SIGTERM received');
  if (server) {
    server.close();
  }
});
