const httpStatus = require('http-status');
const ApiError = require('../utils/ApiError');
const catchAsync = require('../utils/catchAsync');
const { pageService } = require('../services');

const createPage = catchAsync(async (req, res) => {
  const page = await pageService.createPage(req.body);
  res.status(httpStatus.CREATED).send(page);
});

const getAllPages = catchAsync(async (req, res) => {
  const page = await pageService.getAllPages();
  if (!page) {
    throw new ApiError(httpStatus.NOT_FOUND, 'Page not found');
  }
  res.send(page);
});

const getPage = catchAsync(async (req, res) => {
  const page = await pageService.getPageById(req.params.pageId);
  if (!page) {
    throw new ApiError(httpStatus.NOT_FOUND, 'Page not found');
  }
  res.send(page);
});

const updatePage = catchAsync(async (req, res) => {
  const user = await pageService.updatePageById(req.body.pageId, req.body);
  res.send(user);
});

const deletePage = catchAsync(async (req, res) => {
  await pageService.deletePageById(req.params.pageId);
  res.status(httpStatus.NO_CONTENT).send();
});

module.exports = {
  createPage,
  getPage,
  getAllPages,
  updatePage,
  deletePage,
};
