const httpStatus = require('http-status');
const catchAsync = require('../utils/catchAsync');
const licenseService = require('../services/license.service');

const createLicense = catchAsync(async (req, res) => {
  const status = await licenseService.createLicense(req.body);
  res.status(httpStatus.OK).send(status);
});

const updateLicense = catchAsync(async (req, res) => {
  const { licenseId, updateBody, action } = req.body;
  if (action === 'renew') {
    const license = await licenseService.renewLicenseById(licenseId, updateBody);
    res.status(httpStatus.OK).send(license);
  } else {
    const license = await licenseService.updateLicenseById(licenseId, updateBody);
    res.status(httpStatus.OK).send(license);
  }
});

const getAllLicenses = catchAsync(async (req, res) => {
  const licenses = await licenseService.queryLicense({});
  res.status(httpStatus.OK).send(licenses);
});

module.exports = {
  createLicense,
  updateLicense,
  getAllLicenses,
};
