const httpStatus = require('http-status');
const catchAsync = require('../utils/catchAsync');
const { adminService } = require('../services');

const updatePage = catchAsync(async (req, res) => {
  const page = await adminService.updatePage(req.body.pageId, req.body);
  res.status(httpStatus.CREATED).send(page);
});

module.exports = {
  updatePage,
};
